function stop = optimIterPlot2D(x, optimValues, state)
    switch state
        case 'iter'
              updatePlot(x)
              stop = false;
        case 'interrupt'
              stop = true;
        case 'init'
              firstPlot(x)
              stop = false;
        case 'done'
            hold off
            stop = true;
    otherwise
    end
    
    
    
    function firstPlot(x)
        figure;
        myAx = gca;
        my_x = linspace(-20,20,40);
        my_y = my_x.^2 + 3*my_x + 5;
        plot(myAx, my_x, my_y)
        hold on
        y = x.^2 + 3*x + 5;
        scatter(myAx,x,y,'filled','d','r')
    end

    function updatePlot(x)
        myAx = gca;
        y = x.^2 + 3*x + 5;
        hold on
        scatter(myAx,x,y,'filled','d','r')
    end
end

